from collections import defaultdict

def main():
    n = int(input())
    points = [tuple(map(int, input().split())) for _ in range(n)]
    
    greeting_count = 0
    visited = defaultdict(int)
    
    for x, y in points:
        moves = [(x + 1, y), (x - 1, y), (x, y + 1), (x, y - 1)]
        
        for nx, ny in moves:
            greeting_count += visited[(nx, ny)]
        
        for nx, ny in moves:
            visited[(nx, ny)] += 1
    
    print(greeting_count)

if __name__ == "__main__":
    main()